

mEmitSpeed       = 17.0;
mMaxParticles    = 100.50;

pVelocity   = Allocate(2);
pAge        = Allocate(1);
pSpin       = Allocate(1);
pSpinSpeed  = Allocate(1);

SetTexture      ( "smokeparticle.png" );
SetBlendMode   ( kBlendNormal  );
SetNumParticles   ( mMaxParticles );

if not dLocus then
   dLocus= Vec2(0,0); 
end
if not dGoRight then
	dGoRight = false;
end

vVelXa = 90;
vVelXb = 190;
if not dGoRight then
	vVelXa = -vVelXa;
	vVelXb = -vVelXb;
end


pPosition:Init( fRange( Vec2(0,0), Vec2(0,0) )+dLocus );
pVelocity:Init( fRange( Vec2(vVelXa,20), Vec2(vVelXb,70) ) );
pScale:Init( fRange(0.25,1.0) );
pAge:Init(0);
pSpin:Init( -90 );
pSpinSpeed:Init( 0 );

-- ------------------------------------------------------------
-- Particle Parameter Animation Function
pPosition:Anim( pPosition + fTimeScale(pVelocity) );
pScale:Anim( pScale + fTimeScale(1.5) );
pVelocity:Anim( pVelocity + fTimeScale(Vec2(0,-400)) );
pColor:Anim( 
   fFade( pAge,
      Color(1,0,0,0.7),500,
      Color(1,0.4,0,0) ) -- to final color
   );
pSpin:Anim( pSpin + fTimeScale( pSpinSpeed ) );
pUp:Anim( f2dRotation( pSpin ) );
pAge:Anim( pAge+fAge() );
Anim( fExpire( fGreater(pAge,1800) ) );



gActiveTime = 0.0;
gIsDone     = 0;
function Update(seconds)
   if gActiveTime > 0.0 then
      CreateParticles( seconds * mEmitSpeed );
   end
end
